/*
 *	$Header: $
 *
 *	$History: $
 */
#include "stdafx.h"
#include "EnumerateFolders.h"
#include "FileSpec.h"

CEnumerateFolders::CEnumerateFolders() : CObject()
{
}

BOOL CEnumerateFolders::Execute(LPCTSTR szFolder, BOOL bRecurse, DWORD dwCookie, LPCTSTR szFilter)
{
	ASSERT(szFolder);
	ASSERT(AfxIsValidString(szFolder));

	CFileSpec fs(szFolder, szFilter);

	CFileFind ff;
	BOOL	  bWorking = ff.FindFile(fs.GetFullSpec());

	while (bWorking)
	{
		bWorking = ff.FindNextFile();

		if (ff.IsDirectory())
		{
			if (ff.IsDots())
				continue;

			if (OnFolder(ff.GetFilePath() + _T("\\"), dwCookie) == FALSE)
				return FALSE;

			if (bRecurse && Execute(ff.GetFilePath() + _T("\\"), bRecurse, dwCookie, szFilter) == FALSE)
				return FALSE;
		}
		else if (OnFile(ff.GetFilePath(), dwCookie) == FALSE)
			return FALSE;
	}

	return TRUE;
}

BOOL CEnumerateFolders::OnFolder(LPCTSTR /*szFolder*/, DWORD /*dwCookie*/) const
{
	return TRUE;
}

BOOL CEnumerateFolders::OnFile(LPCTSTR /*szFilename*/, DWORD /*dwCookie*/) const
{
	return TRUE;
}
